/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.event;

import java.util.Set;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.entity.EntityTypes;
import kiwiapollo.cobblemontrainerbattle.entity.RandomSpawnableTrainerFactory;
import kiwiapollo.cobblemontrainerbattle.entity.RandomTrainerEntityFactory;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntity;
import kiwiapollo.cobblemontrainerbattle.global.config.ConfigStorage;
import kiwiapollo.cobblemontrainerbattle.item.MiscItems;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;

public class TrainerEntitySpawner
implements ServerTickEvents.EndWorldTick {
    private static final int MAXIMUM_RADIUS = 30;
    private static final int MINIMUM_RADIUS = 5;

    public void onEndTick(class_3218 world) {
        if (this.isTrainerSpawnTick(world.method_8503().method_3780())) {
            for (class_3222 player : world.method_18456()) {
                this.spawnTrainersAroundPlayer(world, player);
            }
        }
    }

    private boolean isTrainerSpawnTick(int ticks) {
        int interval = ConfigStorage.getInstance().getTrainerSpawnIntervalInSeconds() * 20;
        return ticks % interval == 0;
    }

    private void spawnTrainersAroundPlayer(class_3218 world, class_3222 player) {
        try {
            if (!this.hasVsSeeker(player)) {
                return;
            }
            if (!this.isBelowMaximumTrainerSpawnCount(world, (class_1657)player)) {
                return;
            }
            RandomSpawnableTrainerFactory trainerFactory = this.createRandomSpawnableTrainerFactory((class_1263)player.method_31548());
            RandomTrainerEntityFactory entityFactory = new RandomTrainerEntityFactory(trainerFactory);
            TrainerEntity entity = entityFactory.create(EntityTypes.TRAINER, (class_1937)world);
            class_2338 spawnPos = this.getRandomSpawnPosition(world, (class_1657)player);
            entity.method_5725(spawnPos, player.method_36454(), player.method_36455());
            world.method_8649((class_1297)entity);
            CobblemonTrainerBattle.LOGGER.info("Spawned trainer on {} {}", (Object)world.method_27983().method_29177(), (Object)spawnPos);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private RandomSpawnableTrainerFactory createRandomSpawnableTrainerFactory(class_1263 inventory) {
        RandomSpawnableTrainerFactory.Builder builder = new RandomSpawnableTrainerFactory.Builder();
        if (inventory.method_18862(Set.of(MiscItems.BLUE_VS_SEEKER))) {
            builder = builder.addAll();
        }
        if (inventory.method_18862(Set.of(MiscItems.RED_VS_SEEKER))) {
            builder = builder.addRadicalRed();
        }
        if (inventory.method_18862(Set.of(MiscItems.GREEN_VS_SEEKER))) {
            builder = builder.addInclementEmerald();
        }
        if (inventory.method_18862(Set.of(MiscItems.PURPLE_VS_SEEKER))) {
            builder = builder.addSmogon();
        }
        return builder.build();
    }

    private boolean hasVsSeeker(class_3222 player) {
        return player.method_31548().method_18862(Set.of(MiscItems.BLUE_VS_SEEKER, MiscItems.RED_VS_SEEKER, MiscItems.GREEN_VS_SEEKER, MiscItems.PURPLE_VS_SEEKER));
    }

    private boolean isBelowMaximumTrainerSpawnCount(class_3218 world, class_1657 player) {
        int count = world.method_18023(EntityTypes.TRAINER, player.method_5829().method_1014(30.0), entity -> true).size();
        return count < ConfigStorage.getInstance().getMaximumTrainerSpawnCount();
    }

    private class_2338 getRandomSpawnPosition(class_3218 world, class_1657 player) throws IllegalStateException {
        class_2338 playerPos = player.method_24515();
        int MAXIMUM_RETRIES = 50;
        for (int i = 0; i < 50; ++i) {
            int xOffset = class_5819.method_43047().method_39332(5, 30) * class_5819.method_43047().method_39332(-1, 1);
            int zOffset = class_5819.method_43047().method_39332(5, 30) * class_5819.method_43047().method_39332(-1, 1);
            int yOffset = class_5819.method_43047().method_39332(-30, 30);
            class_2338 spawnPos = playerPos.method_10069(xOffset, yOffset, zOffset);
            boolean isSolidGround = world.method_8320(spawnPos.method_10074()).method_26212((class_1922)world, spawnPos.method_10074());
            boolean isEmptySpace = world.method_8320(spawnPos).method_26215();
            if (!isSolidGround || !isEmptySpace) continue;
            return spawnPos;
        }
        throw new IllegalStateException();
    }
}

